/* Spike Animation — League-only, PNG sequence, per-team render (robust logo swapping) */

// --- paste at the very top of batch_ScoringAnimations4.jsx ---

// robust env reader: $.getenv first, AE_BRIDGE_JSON (JSON) fallback
function __read_env_json(){
  try{
    var p = $.getenv("AE_BRIDGE_JSON");
    if (!p) return {};
    var f = File(p); if (!f.exists) return {};
    f.open("r"); var txt = f.read(); f.close();
    // Older ExtendScript has no JSON.parse; eval is OK on our own file
    return eval("("+txt+")");
  }catch(e){ return {}; }
}
var __BRIDGE_ENV = __read_env_json();

function env(k, d){
  var v = $.getenv(k);
  if (v===null || v===undefined || v==="") {
    v = (__BRIDGE_ENV && __BRIDGE_ENV[k] !== undefined) ? __BRIDGE_ENV[k] : d;
  }
  return v;
}

// optional one-line confirmation in AE Console
$.writeln(
  "[CFG] COMP=" + env("AE_COMP","<nil>")
  + "  LEAGUE=" + env("AE_LEAGUE","<nil>")
  + "  OUTDIR=" + env("AE_OUTDIR","<nil>")
  + "  OM_TPL=" + env("AE_OM_TEMPLATE","<nil>")
);


(function () {
  // ---------- tiny utils ----------
  function env(k,d){ var v=$.getenv(k); return (v===null||v===undefined||v==="")?d:v; }
  function fail(msg){ alert(msg); throw new Error(msg); }
  function trim(s){ var t=String(s||""); while(/^[ \t\r\n]/.test(t)) t=t.substring(1); while(/[ \t\r\n]$/.test(t)) t=t.substring(0,t.length-1); return t; }
  function toLower(s){ return String(s||"").toLowerCase(); }
  function clamp01(v){ return Math.max(0, Math.min(1, v)); }
  function sanitize(s){ var bad='\\/:*?"<>|', t=String(s||""), out="", i, ch; for(i=0;i<t.length;i++){ ch=t.charAt(i); out+=(bad.indexOf(ch)>=0?"-":ch);} return out; }
  function hasExt(p){ return /\.[A-Za-z0-9]+$/.test(p); }
  function numOr(v,def){ var n=parseFloat(v); return (isFinite(n) ? n : def); }
  function safeColor(c){ if (!c || c.length!==3) return [0,0,0]; function cl(x){ return (x<0?0:(x>1?1:x)); } return [cl(numOr(c[0],0)),cl(numOr(c[1],0)),cl(numOr(c[2],0))]; }
  function cleanValue(v){
    if (!v && v!==0) return "";
    var s = String(v);
    s = s.replace(/^["']+|["']+$/g, '');
    s = s.replace(/[\u00A0\u1680\u180E\u2000-\u200B\u202F\u205F\u3000]/g, ' ');
    s = s.replace(/\s+/g, ' ');
    s = s.replace(/^[ \t\r\n]+|[ \t\r\n]+$/g, '');
    return s;
  }

  // Color helpers
  function isBlackOrNearlyBlack(c){ if (!c || c.length!==3) return true; return (c[0] <= 0.05 && c[1] <= 0.05 && c[2] <= 0.05); }
  function getAccentColor(primary, secondary){ return (!isBlackOrNearlyBlack(primary)) ? [primary[0]*0.5, primary[1]*0.5, primary[2]*0.5] : [secondary[0]*0.5, secondary[1]*0.5, secondary[2]*0.5]; }
  function rgb01(r,g,b){ return [clamp01(numOr(r,0)/255), clamp01(numOr(g,0)/255), clamp01(numOr(b,0)/255)]; }
  function trySet(p,v){ if (!p) return false; try{ p.setValue(v); return true; }catch(e){ return false; } }

  function unhideAll(comp){
    try{ comp.hideShyLayers=false; }catch(e){}
    for (var i=1;i<=comp.numLayers;i++){
      var L=comp.layer(i);
      try{ L.enabled=true; }catch(e){}
      try{ L.shy=false; }catch(e){}
      try{ if (L.source && (L.source instanceof CompItem)) unhideAll(L.source); }catch(e){}
    }
  }

  // ---------- env ----------
  var PROJECT   = env("AE_PROJECT", null);
  var CSV_PATH  = env("AE_CSV", null);
  var COMP_NAME = env("AE_COMP","Comp-TD-192");

  var TEAMNAME_LAYER    = env("AE_TEAMNAME_LAYER","TeamName");
  var SOLID_LAYER       = env("AE_SOLID_LAYER","Solid");
  var ART_PRECOMP_LAYER = env("AE_ART_PRECOMP_LAYER","ART_PRECOMP");
  var SPIKEMAN_LAYER    = env("AE_SPIKEMAN_LAYER","SpikeMan");
  var TOUCHDOWN_LAYER   = env("AE_TOUCHDOWN_LAYER","TOUCHDOWN");

  var LOGO_LAYER = env("AE_LOGO_LAYER","TeamLogo"); // top-level fallback
  var LOGO_DIR   = env("AE_LOGO_DIR","");
  var LOGO_TPL   = env("AE_LOGO_PATH_TEMPLATE","{league}/{abbr}");
  var LOGO_EXTS  = env("AE_LOGO_EXTS","png,jpg,jpeg,svg,ai,psd").split(",");
  var LOGO_CASE  = env("AE_LOGO_CASE","keep");

  var LEAGUE    = env("AE_LEAGUE","");
  var LIMIT_STR = env("AE_LIMIT","");
  var LIMIT     = (LIMIT_STR && !isNaN(parseInt(LIMIT_STR,10))) ? parseInt(LIMIT_STR,10) : null;

  var OUTDIR    = env("AE_OUTDIR","");
  var PATH_TPL  = env("AE_PATH_TEMPLATE","{league}");
  var ANIM_NAME = env("AE_ANIM","SPIKE");
  var RS_TPL    = env("AE_RS_TEMPLATE","Best Settings");
  var OM_TPL    = env("AE_OM_TEMPLATE","PNG Sequence");
  var PURGE     = (env("AE_PURGE_BEFORE_RENDER","1")==="1");
  var NO_RENDER = (env("AE_NO_RENDER","0")==="1");
  var QUIT_APP  = (env("AE_QUIT","1")==="1");

  // ---------- CSV ----------
  function openRead(path){ var f=new File(path); if(!f.exists) fail("File not found: "+path); f.open("r"); var s=f.read(); f.close(); return s; }
  function parseCSV(txt){
    var raw=txt.split(/\r\n|\n|\r/), lines=[], i; for(i=0;i<raw.length;i++){ var L=raw[i]; if(L && !/^\s*$/.test(L)) lines.push(L); }
    var rows=[], c; for(i=0;i<lines.length;i++){ var line=lines[i]; var cells=(line.indexOf("\t")!==-1? line.split("\t") : line.split(",")); 
      for(c=0;c<cells.length;c++){ var cell=trim(cells[c]); if(cell.charAt(0)=='"' && cell.charAt(cell.length-1)=='"') cell=cell.substring(1,cell.length-1); cells[c]=cell; }
      rows.push(cells);
    }
    if(rows.length<2) fail("CSV has no data."); return rows;
  }
  function headerIdx(h){
    var m={}, i; for(i=0;i<h.length;i++) m[toLower(h[i])]=i;
    function need(x){ if(m[x]===undefined) fail("Missing column: "+x); }
    need("abbreviation"); need("r"); need("g"); need("b"); need("r2"); need("g2"); need("b2");
    return m;
  }
  function optIdx(idx, names){ for (var i=0;i<names.length;i++){ var k=names[i]; if (idx[k]!==undefined) return idx[k]; } return undefined; }
  function buildTeams(rows){
    var h=rows[0], idx=headerIdx(h), out=[], i;
    var hasLeague=(idx["league"]!==undefined);
    var nameIdx  = optIdx(idx, ["displayname","name"]);
    var confIdx  = optIdx(idx, ["conference","conf","group"]);
    for(i=1;i<rows.length;i++){
      var r=rows[i], ab=cleanValue(r[idx["abbreviation"]]); if(!ab) continue;
      out.push({
        abbr: ab,
        league: hasLeague ? cleanValue(r[idx["league"]]) : cleanValue(LEAGUE||"NA"),
        conference: (confIdx!==undefined ? cleanValue(r[confIdx]) : ""),
        name: (nameIdx!==undefined ? cleanValue(r[nameIdx]) : ab),
        primary:   rgb01(r[idx["r"]],  r[idx["g"]],  r[idx["b"]]),
        secondary: rgb01(r[idx["r2"]], r[idx["g2"]], r[idx["b2"]])
      });
    }
    return out;
  }
  function pickTeamsLeagueOnly(all){
    var res=[], i;
    var targetLeague = cleanValue(LEAGUE).toUpperCase();
    if (!targetLeague) fail("AE_LEAGUE is required for league-only mode.");
    for (i=0; i<all.length; i++){
      var teamLeague = cleanValue(all[i].league).toUpperCase();
      if (teamLeague === targetLeague) res.push(all[i]);
    }
    if (LIMIT && res.length>LIMIT) res = res.slice(0, LIMIT);
    return res;
  }

  // ---------- AE helpers ----------
  function findComp(name){ for(var i=1;i<=app.project.numItems;i++){ var it=app.project.item(i); if(it instanceof CompItem && it.name===name) return it; } return null; }
  function getLayer(comp, name){ try{ return comp.layer(name); }catch(e){ return null; } }

  function setTextFillColor(layer, color){
    var st=layer && layer.property("Source Text"); if(!st) return false;
    var td=st.value; td.applyFill=true; td.fillColor=safeColor(color); td.applyStroke=false;
    try{ st.setValue(td); return true; }catch(e){ return false; }
  }
  function setSolidColor(layer, color){
    try{
      var src = layer.source;
      if (src && src.mainSource && src.mainSource.color !== undefined) {
        src.mainSource.color = safeColor(color);
        return true;
      }
    }catch(e){}
    var fx = layer.property("Effects");
    if (fx){
      var fill = fx.property("Fill") || fx.addProperty("ADBE Fill");
      if (fill){ return trySet(fill.property("Color"), safeColor(color)); }
    }
    return false;
  }
  function setLayerColor(layer, color){
    var fx = layer.property("Effects"); if (!fx) return false;
    var updated = false;
    for (var i=1; i<=fx.numProperties; i++){
      var effect = fx.property(i);
      if (effect.matchName === "ADBE Color Control"){
        var colorProp = effect.property("Color");
        if (colorProp && trySet(colorProp, safeColor(color))) updated = true;
      }
    }
    if (!updated){
      var fill=null;
      for (var j=1; j<=fx.numProperties; j++){
        if (fx.property(j).matchName === "ADBE Fill"){ fill = fx.property(j); break; }
      }
      if (!fill && layer.adjustmentLayer){ fill = fx.addProperty("ADBE Fill"); }
      if (fill){ return trySet(fill.property("Color"), safeColor(color)); }
    }
    return updated;
  }
  function setTintEffectColors(layer, color){
    var fx = layer.property("Effects"); if (!fx) return false;
    var tint=null;
    for (var i=1;i<=fx.numProperties;i++){ var e=fx.property(i); if (e.matchName==="ADBE Tint"){ tint=e; break; } }
    if (!tint) return false;
    var ok=false;
    var mb=tint.property("Map Black To"); if (mb && trySet(mb, safeColor(color))) ok=true;
    var mw=tint.property("Map White To"); if (mw && trySet(mw, safeColor(color))) ok=true;
    return ok;
  }
  function processPrecompColorLayers(comp, primaryColor, secondaryColor, accentColor){
    var processed=0;
    for (var i=1;i<=comp.numLayers;i++){
      var layer=comp.layer(i);
      var nm = layer.name;
      var up = nm.toUpperCase();

      if (nm==="Player-Primary" || up==="PLAYER-PRIMARY"){ if (setTintEffectColors(layer, primaryColor)) processed++; }
      else if (nm==="Player-Secondary" || up==="PLAYER-SECONDARY"){ if (setTintEffectColors(layer, secondaryColor)) processed++; }
      else if (nm==="PS-Primary" || up==="PS-PRIMARY"){ if (setTintEffectColors(layer, primaryColor)) processed++; }
      else if (nm==="PS-Secondary" || up==="PS-SECONDARY"){ if (setTintEffectColors(layer, secondaryColor)) processed++; }
      else if (nm==="PS-Accent" || up==="PS-ACCENT"){ if (setTintEffectColors(layer, accentColor)) processed++; }

      var fx = layer.property("Effects");
      if (fx){
        for (var j=1;j<=fx.numProperties;j++){
          var eff=fx.property(j);
          if (eff.matchName==="ADBE Color Control"){
            var ccName = eff.name.toUpperCase();
            var col = (ccName.indexOf("PRIMARY")!==-1)?primaryColor:(ccName.indexOf("SECONDARY")!==-1)?secondaryColor:(ccName.indexOf("ACCENT")!==-1)?accentColor:null;
            if (col){ var cp=eff.property("Color"); if (cp && trySet(cp, safeColor(col))) processed++; }
          }
        }
      }
      try{ if (layer.source && (layer.source instanceof CompItem)) processed += processPrecompColorLayers(layer.source, primaryColor, secondaryColor, accentColor); }catch(e){}
    }
    return processed;
  }

  // ---------- Robust logo replacement ----------
  function applyCase(s){
    if (LOGO_CASE==="upper") return String(s||"").toUpperCase();
    if (LOGO_CASE==="lower") return String(s||"").toLowerCase();
    return String(s||"");
  }
  function findLogoFile(league, abbr){
    if (!LOGO_DIR) return null;
    var L = applyCase(league||"");
    var A = applyCase(abbr||"");
    var tpl = LOGO_TPL.replace("{league}",L).replace("{abbr}",A)
                      .replace("{league_lc}", String(league||"").toLowerCase())
                      .replace("{abbr_lc}",   String(abbr||"").toLowerCase())
                      .replace("{league_uc}", String(league||"").toUpperCase())
                      .replace("{abbr_uc}",   String(abbr||"").toUpperCase());
    if (hasExt(tpl)){
      var f1 = new File(LOGO_DIR + "/" + tpl);
      return f1.exists ? f1 : null;
    }
    for (var i=0;i<LOGO_EXTS.length;i++){
      var f2 = new File(LOGO_DIR + "/" + tpl + "." + trim(LOGO_EXTS[i]));
      if (f2.exists) return f2;
    }
    return null;
  }

  // Import once/cache
  var __logoCache = {};
  function importLogoFootage(league, abbr){
    var f = findLogoFile(league, abbr); if (!f) return null;
    var key = f.fsName;
    if (__logoCache[key]) return __logoCache[key];
    var io = new ImportOptions(f); if (!io.canImportAs(ImportAsType.FOOTAGE)) return null;
    var footage = app.project.importFile(io);
    __logoCache[key] = footage;
    return footage;
  }

  // Replace by exact layer name IF it exists (top-level convenience)
  function replaceLogoTopLevel(comp, layerName, footage){
    var ly = getLayer(comp, layerName);
    if (!ly) return false;
    try { ly.replaceSource(footage, false); return true; } catch(e){ return false; }
  }

  // Replace every layer named "TeamLogo*" recursively in a comp graph
  function replaceTeamLogoDeep(inComp, footage, depth){
    if (!inComp || !(inComp instanceof CompItem)) return 0;
    if (depth > 6) return 0;
    var changed = 0, reTL = /^TeamLogo(?:[\s_()-]*\d*)?$/i;

    for (var i=1; i<=inComp.numLayers; i++){
      var L = inComp.layer(i);
      var nm = String(L && L.name || "");
      if (reTL.test(nm)){
        try { L.replaceSource(footage, false); changed++; } catch(e){}
      }
      try {
        if (L && L.source && (L.source instanceof CompItem)){
          changed += replaceTeamLogoDeep(L.source, footage, depth+1);
        }
      } catch(e){}
    }
    return changed;
  }

  // ---------- run ----------
  if (app.beginSuppressDialogs){ try{ app.beginSuppressDialogs(); }catch(e){} }
  app.beginUndoGroup("Spike Animation - League Only - PNG Seq");

  if(!PROJECT) fail("AE_PROJECT env not set.");
  var aep=new File(PROJECT); if(!aep.exists) fail("AE_PROJECT not found: "+PROJECT);
  app.open(aep);

  if(!CSV_PATH) fail("AE_CSV env not set.");
  if(!LEAGUE || cleanValue(LEAGUE)==="") fail("AE_LEAGUE is required.");

  var rows=parseCSV(openRead(CSV_PATH));
  var teams=buildTeams(rows);
  var todo=pickTeamsLeagueOnly(teams);
  if(!todo.length) fail("No teams matched league: " + LEAGUE);

  var rootComp=findComp(COMP_NAME); if(!rootComp) fail("Comp not found: "+COMP_NAME);
  unhideAll(rootComp);

  var rootOut = OUTDIR ? new Folder(OUTDIR) : (app.project.file ? app.project.file.parent : Folder.desktop);
  if(!rootOut.exists) rootOut.create();

  // Ensure queue is empty
  while(app.project.renderQueue.numItems > 0) { app.project.renderQueue.item(1).remove(); }

  var ANIM_SAFE = (function(s){ var v=cleanValue(s); return v.replace(/^[\s_\-]+/,""); })(ANIM_NAME);

  for (var i=0;i<todo.length;i++){
    var t = todo[i];
    var primaryColor   = safeColor(t.primary);
    var secondaryColor = safeColor(t.secondary);
    var accentColor    = getAccentColor(primaryColor, secondaryColor);

    // Color updates
    var solidLy = getLayer(rootComp, SOLID_LAYER); if (solidLy) setSolidColor(solidLy, primaryColor);
    var nameLy  = getLayer(rootComp, TEAMNAME_LAYER);
    if (nameLy){
      setTextFillColor(nameLy, secondaryColor);
      var st=nameLy.property("Source Text");
      if (st){ var td=st.value; td.text = String(t.abbr||""); try{ st.setValue(td);}catch(e){} }
    }
    var tdl = getLayer(rootComp, TOUCHDOWN_LAYER); if (tdl) setTextFillColor(tdl, accentColor);

    var artLayer = getLayer(rootComp, ART_PRECOMP_LAYER);
    if (artLayer && artLayer.source && (artLayer.source instanceof CompItem)){ processPrecompColorLayers(artLayer.source, primaryColor, secondaryColor, accentColor); }
    var spikeLayer = getLayer(rootComp, SPIKEMAN_LAYER);
    if (spikeLayer && spikeLayer.source && (spikeLayer.source instanceof CompItem)){ processPrecompColorLayers(spikeLayer.source, primaryColor, secondaryColor, accentColor); }

    // Logo (robust): import once, replace top-level if present, and deep-replace any TeamLogo* inside precomps
    var logoFootage = importLogoFootage(t.league, t.abbr);
    if (logoFootage){
      replaceLogoTopLevel(rootComp, LOGO_LAYER, logoFootage);     // no-op if layer doesn't exist
      replaceTeamLogoDeep(rootComp, logoFootage, 0);              // hits TeamLogo, TeamLogo 2, etc., everywhere below
    }

    if (PURGE && app.purge) { try { app.purge(PurgeTarget.ALL_CACHES); } catch(e) {} }

    if (!NO_RENDER){
      // OUTDIR/{league}/LEAGUE_LEAGUE_ABBR_ANIM (your original rule)
      var leagueBase = cleanValue(t.league).toUpperCase();
      var confLabel  = cleanValue(t.conference).toUpperCase();
      var sub = PATH_TPL.replace("{league}", sanitize(leagueBase)).replace("{abbr}", sanitize(t.abbr));
      var outLevel1 = new Folder(rootOut.fsName + "/" + sub);
      if (!outLevel1.exists) outLevel1.create();

      var animFolderName = (confLabel
        ? (sanitize(leagueBase) + "_" + sanitize(confLabel) + "_" + sanitize(t.abbr) + "_" + ANIM_SAFE)
        : (sanitize(leagueBase) + "_" + sanitize(leagueBase) + "_" + sanitize(t.abbr) + "_" + ANIM_SAFE));

      var animFolder = new Folder(outLevel1.fsName + "/" + animFolderName);
      if (!animFolder.exists) animFolder.create();

      var outFile = File(animFolder.fsName + "/0000");

      // single item per team → render immediately
      while(app.project.renderQueue.numItems > 0) { app.project.renderQueue.item(1).remove(); }
      var rqItem = app.project.renderQueue.items.add(rootComp);
      try{ rqItem.applyTemplate(RS_TPL); }catch(e){}
      var om = rqItem.outputModule(1);
      try{ om.applyTemplate(OM_TPL); }catch(e){}
      om.file = outFile;

      app.project.renderQueue.render();
      while(app.project.renderQueue.numItems > 0) { app.project.renderQueue.item(1).remove(); }
    }
  }

  app.endUndoGroup();
  if (app.endSuppressDialogs){ try{ app.endSuppressDialogs(); }catch(e){} }
  if (QUIT_APP) app.quit();
})();
